/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_wait.c,v 1.24 2005/06/29 00:23:16 eugene Exp $";

#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/time.h>
#include <errno.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t
mx_wait(mx_endpoint_t endpoint,
        mx_request_t *handle,
	uint32_t timeout,
        mx_status_t *status,
	uint32_t *result)
{
    struct mx_endpoint *pp;
    struct mx_post *post;

    if (handle == NULL){
        return (MX_BAD_REQUEST);
    }
    pp = (struct mx_endpoint *)endpoint;
    
    pthread_mutex_lock(&Mx_po_lock);

    post = &handle[0]->post;
    if(post->complete){
      *result = 1;
      goto handle_completed;
    } else {
      int rs;
      struct timespec ts;
      struct timeval  tv;
      gettimeofday(&tv, NULL);
      ts.tv_sec = tv.tv_sec + timeout/1000;
      ts.tv_nsec = tv.tv_usec * 1000 + 
	(timeout % 1000) * 1000 * 1000;
      rs = pthread_cond_timedwait(&post->wait_cond, 
				  &Mx_po_lock, &ts);
      if (rs == ETIMEDOUT){
	*result = 0;
	pthread_mutex_unlock(&Mx_po_lock);
	return MX_SUCCESS;
      }
      *result = 1;
      goto handle_completed;
    }

 handle_completed:
    /*
     * got a completed post!  Call the post's callback and return the handle
     * of the completed post.
     */
    
    /* pull the post off the list */
    MX_LIST_REMOVE(post);
    
    /* return status */
    if (status != NULL) {
        *status = post->status;
    }
    
    /* destroy this handle */
    mx_destroy_post(post);
    
    pthread_mutex_unlock(&Mx_po_lock);
    
    return MX_SUCCESS;
}
